% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_stability}
\alias{print.tna_stability}
\title{Print Centrality Stability Results}
\usage{
\method{print}{tna_stability}(x, ...)
}
\arguments{
\item{x}{A \code{tna_stability} object.}

\item{...}{Ignored.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Centrality Stability Results
}
\examples{
model <- tna(group_regulation)
# Small number of iterations and drop proportions for CRAN
cs <- estimate_cs(
  model,
  measures = c("InStrength", "OutStrength"),
  drop_prop = seq(0.3, 0.9, by = 0.2),
  iter = 10
)
print(cs)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_permutation}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
