% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_multi_deg_all.R
\name{draw_heatmap2}
\alias{draw_heatmap2}
\title{draw heatmap plots}
\usage{
draw_heatmap2(exp, group_list, deg, my_genes = NULL, heat_union = TRUE, ...)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{deg}{a data.frame created by Differential analysis}

\item{my_genes}{genes for pheatmap}

\item{heat_union}{logical ,use union or intersect DEGs for heatmap}

\item{...}{other parameters from draw_heatmap}
}
\value{
a heatmap plot according to \code{exp} and grouped by \code{group}.
}
\description{
print heatmap plots for expression matrix and group by group_list paramter
}
\examples{
\dontrun{
gse = "GSE474"
geo = geo_download(gse,destdir=tempdir())
geo$exp[1:4,1:4]
geo$exp=log2(geo$exp+1)
group_list=ifelse(stringr::str_detect(geo$pd$title,"MObese"),"MObese",
ifelse(stringr::str_detect(geo$pd$title,"NonObese"),"NonObese","Obese"))
group_list=factor(group_list,levels = c("NonObese","Obese","MObese"))
find_anno(geo$gpl)
ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
deg = multi_deg(geo$exp,group_list,ids,adjust = FALSE)
draw_heatmap2(geo$exp,group_list,deg)
}
}
\seealso{
\code{\link{draw_pca}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
