% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqa.R
\name{iqa}
\alias{iqa}
\title{Water Quality Index (WQI / IQA)}
\usage{
iqa(
  df,
  pesos = c(od = 0.17, coliformes = 0.15, dbo = 0.1, nt_total = 0.1, p_total = 0.1,
    turbidez = 0.08, tds = 0.08, pH = 0.12, temperatura = 0.1),
  method = c("CETESB_approx"),
  na_rm = FALSE
)
}
\arguments{
\item{df}{Data frame (or tibble) with required parameter columns.
Expected defaults (Portuguese names): \code{od}, \code{coliformes},
\code{dbo}, \code{nt_total}, \code{p_total}, \code{turbidez},
\code{tds}, \code{ph} (or \code{pH}), \code{temperatura}.}

\item{pesos}{Named numeric weights for each parameter (sum not required).
Defaults follow CETESB/NSF practice:
\itemize{
\item \code{od = 0.17}
\item \code{coliformes = 0.15}
\item \code{dbo = 0.10}
\item \code{nt_total = 0.10}
\item \code{p_total = 0.10}
\item \code{turbidez = 0.08}
\item \code{tds = 0.08}
\item \code{pH = 0.12} (mapped to column \code{ph} if needed)
\item \code{temperatura = 0.10}
}}

\item{method}{Character scalar; interpolation table set. Currently
only \code{"CETESB_approx"}.}

\item{na_rm}{Logical; if \code{FALSE} (default), rows containing
missing Qi values will trigger an error. If \code{TRUE}, the IQA
is computed using only available parameters, with the denominator
adjusted to the sum of the weights of present parameters.}
}
\value{
The input \code{df} with an added numeric column \code{IQA}. The
attribute \code{"iqa_method"} is set on the returned data.frame/tibble.
}
\description{
Computes IQA/WQI by combining parameter-specific sub-scores (Qi) via
a \strong{weighted mean}. Sub-scores are obtained by piecewise-linear
interpolation over approximate curves (CETESB/NSF-like).
}
\details{
Column name compatibility:
\itemize{
\item The interpolation table uses the key \code{"pH"}.
If your data uses a \code{ph} column (lowercase), it is
automatically mapped to the \code{"pH"} curve.
\item All other parameter names are used as-is.
}

Values are clipped into \code{[0, 100]} after aggregation.
}
\examples{
# Minimal example using the demo data:
d <- wq_demo
d2 <- iqa(d, na_rm = TRUE)
head(d2$IQA)

}
