% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{mutate.}
\alias{mutate.}
\title{Add/modify/delete columns}
\usage{
mutate.(
  .df,
  ...,
  .by = NULL,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to add/modify}

\item{.by}{Columns to group by}

\item{.keep}{\emph{experimental}:
This is an experimental argument that allows you to control which columns
from \code{.df} are retained in the output:
\itemize{
\item \code{"all"}, the default, retains all variables.
\item \code{"used"} keeps any variables used to make new variables; it's useful
for checking your work as it displays inputs and outputs side-by-side.
\item \code{"unused"} keeps only existing variables \strong{not} used to make new
variables.
\item \code{"none"}, only keeps grouping keys (like \code{\link[=transmute]{transmute()}}).
}}

\item{.before, .after}{Optionally indicate where new columns should be placed.
Defaults to the right side of the data frame.}
}
\description{
With \code{mutate()} you can do 3 things:
\itemize{
\item Add new columns
\item Modify existing columns
\item Delete columns
}
}
\examples{
df <- data.table(
  a = 1:3,
  b = 4:6,
  c = c("a", "a", "b")
)

df \%>\%
  mutate(double_a = a * 2,
         a_plus_b = a + b)

df \%>\%
  mutate(double_a = a * 2,
         avg_a = mean(a),
         .by = c)

df \%>\%
  mutate(double_a = a * 2, .keep = "used")

df \%>\%
  mutate(double_a = a * 2, .after = a)
}
\keyword{internal}
