% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyprompt.R
\name{tidyprompt}
\alias{tidyprompt}
\title{Create a \linkS4class{tidyprompt} object}
\usage{
tidyprompt(input)
}
\arguments{
\item{input}{A string, a chat history, a list containing
a chat history under key '$chat_history', or a \linkS4class{tidyprompt} object}
}
\value{
A \linkS4class{tidyprompt} object
}
\description{
This is a wrapper around the \linkS4class{tidyprompt} constructor.
}
\details{
Different types of input are accepted for initialization of
a \linkS4class{tidyprompt} object:
\itemize{
\item A single character string. This will be used as the base prompt

\item A dataframe which is a valid chat history (see \code{\link[=chat_history]{chat_history()}})

\item A list containing a valid chat history under '$chat_history'
(e.g., a result from \code{\link[=send_prompt]{send_prompt()}} when using 'return_mode' = "full")

\item A \linkS4class{tidyprompt} object. This will be checked for validity and, if valid,
the fields are copied to the object which is returned from this method
}
When passing a dataframe or list with a chat history, the last row of the
chat history must have role 'user'; this row will be used as the base prompt.
If the first row of the chat history has role 'system', it will be used
as the system prompt.
}
\examples{
prompt <- tidyprompt("Hi!")
print(prompt)

# Add to a tidyprompt using a prompt wrap:
prompt <- tidyprompt("Hi!") |>
  add_text("How are you?")
print(prompt)

# Strings can be input for prompt wraps; therefore,
#   a call to tidyprompt() is not necessary:
prompt <- "Hi" |>
  add_text("How are you?")

# Example of adding extraction & validation with a prompt_wrap():
prompt <- "Hi" |>
  add_text("What is 5 + 5?") |>
  answer_as_integer()

\dontrun{
  # tidyprompt objects are evaluated by send_prompt(), which will
  #   handle construct the prompt text, send it to the LLM provider,
  #   and apply the extraction and validation functions from the tidyprompt object
  prompt |>
    send_prompt(llm_provider_ollama())
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   Hi
  #
  #   What is 5 + 5?
  #
  #   You must answer with only an integer (use no other characters).
  # --- Receiving response from LLM provider: ---
  #   10
  # [1] 10

  # See prompt_wrap() and send_prompt() for more details
}

# `tidyprompt` objects may be validated with these helpers:
is_tidyprompt(prompt) # Returns TRUE if input is a valid tidyprompt object

# Get base prompt text
base_prompt <- prompt$base_prompt

# Get all prompt wraps
prompt_wraps <- prompt$get_prompt_wraps()
# Alternative:
prompt_wraps <- get_prompt_wraps(prompt)

# Construct prompt text
prompt_text <- prompt$construct_prompt_text()
# Alternative:
prompt_text <- construct_prompt_text(prompt)

# Set chat history (affecting also the base prompt)
chat_history <- data.frame(
  role = c("user", "assistant", "user"),
  content = c("What is 5 + 5?", "10", "And what is 5 + 6?")
)
prompt$set_chat_history(chat_history)

# Get chat history
chat_history <- prompt$get_chat_history()
}
\seealso{
Other tidyprompt: 
\code{\link{construct_prompt_text}()},
\code{\link{get_chat_history}()},
\code{\link{get_prompt_wraps}()},
\code{\link{is_tidyprompt}()},
\code{\link{set_chat_history}()},
\code{\link{tidyprompt-class}}
}
\concept{tidyprompt}
