% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thaipdf.R
\name{thaipdf_document}
\alias{thaipdf_document}
\title{Convert to a PDF/LaTeX document with Thai Language Compatibility}
\usage{
thaipdf_document(thai_font = "TH Sarabun New", line_spacing = 1.5, ...)
}
\arguments{
\item{thai_font}{(Character) Name of the Thai font to use. Default font is "TH Sarabun New". It can be any Thai font that installed in your system.}

\item{line_spacing}{(Numeric) Spacing between each line. Line spacing 1.5 is recommended for Thai language (default).}

\item{...}{Arguments to pass to \href{https://pkgs.rstudio.com/rmarkdown/reference/pdf_document.html}{\code{pdf_document()}}. You may supply any valid arguments of \code{\link[=pdf_document]{pdf_document()}} except
for \code{includes} and \code{latex_engine}.}
}
\value{
An S3 object of class "rmarkdown_output_format" to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}
}
\description{
\strong{Thai language} supported conversion of R Markdown to a PDF or LaTeX document.
It is a wrapper around \href{https://pkgs.rstudio.com/rmarkdown/reference/pdf_document.html}{\code{rmarkdown::pdf_document()}}.
}
\details{
To achieve Thai language compatibility for \LaTeX,
This function injects preamble fragment of Thai \LaTeX typesetting into the preamble of output \LaTeX via \href{https://pkgs.rstudio.com/rmarkdown/reference/includes.html}{\code{includes}} argument,
and set \code{latex_engine} to "xelatex".
}
\examples{
\dontrun{
library(rmarkdown)

 # Simple Conversion
 render("input.Rmd", output_format = thaipdf::thaipdf_document())

 # Render with Thai font "Laksaman", font size 10pt, enable table of contents
 render("input.Rmd",
        output_format = thaipdf::thaipdf_document(
          thai_font = "Laksaman", # you must have this font in your system
          toc = TRUE,
          pandoc_args = pandoc_metadata_arg("fontsize", "10pt")
        ))
}
}
\seealso{
\itemize{
\item How to use \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document}}, please see \href{https://bookdown.org/yihui/rmarkdown/pdf-document.html#other-features}{official documentation}.
\item How to use \code{\link[=thaipdf_book]{thaipdf_book()}}.
}
}
