% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat.R
\name{testex-testthat}
\alias{testex-testthat}
\title{Support for \code{testthat} Expectations}
\description{
\code{testthat} support is managed through a "style" provided to \code{\link{testex}}.
When using the \code{testthat} style (automatically when using the \verb{@testthat}
tag), expectations are processed such that they always refer to the previous
example. Special care is taken to manage propagation of this value through
your test code, regardless of how \code{testthat} is executed.
}
\examples{
\dontshow{if (requireNamespace("testthat", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# example code
1 + 2

# within `testex` block, test code refers to previous result with `.`
testex(style = "testthat", srcref = "abc.R:1:3", { \dontshow{
  . <- 3 # needed because roxygen2 @examplesIf mutates .Last.value
  }
  test_that("addition holds up", {
    expect_equal(., 3)
  })
})
\dontshow{\}) # examplesIf}
}
