% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{stress2grid}
\alias{stress2grid}
\title{Spatial interpolation of SHmax}
\source{
\url{https://github.com/MorZieg/Stress2Grid}
}
\usage{
stress2grid(
  x,
  stat = c("mean", "median"),
  grid = NULL,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2.5,
  min_data = 3,
  threshold = 25,
  arte_thres = 200,
  method_weighting = FALSE,
  quality_weighting = TRUE,
  dist_weight = c("inverse", "linear", "none"),
  dist_threshold = 0.1,
  R_range = seq(50, 1000, 50),
  ...
)
}
\arguments{
\item{x}{\code{sf} object containing
\describe{
\item{azi}{SHmax in degree}
\item{unc}{Uncertainties of SHmax in degree}
\item{type}{Methods used for the determination of the direction of SHmax}
}}

\item{stat}{Should the direction of interpolated SHmax be based  on the
circular mean and standard deviation (\code{"mean"}, the default) or on the
circular median
and interquartile range (\code{"median"})?}

\item{grid}{(optional) Point object of class \code{sf}.}

\item{lon_range, lat_range}{(optional) numeric vector specifying the minimum
and maximum longitudes and latitudes (are ignored if \code{"grid"} is specified).}

\item{gridsize}{Numeric. Target spacing of the regular grid in decimal
degree. Default is 2.5. (is ignored if \code{"grid"} is specified)}

\item{min_data}{Integer. Minimum number of data per bin. Default is 3}

\item{threshold}{Numeric. Threshold for deviation of direction. Default is
25}

\item{arte_thres}{Numeric. Maximum distance (in km) of the gridpoint to the
next
datapoint. Default is 200}

\item{method_weighting}{Logical. If a method weighting should be applied:
Default is \code{FALSE}.}

\item{quality_weighting}{Logical. If a quality weighting should be applied:
Default is
\code{TRUE}.}

\item{dist_weight}{Distance weighting method which should be used. One of
\code{"none"}, \code{"linear"}, or \code{"inverse"} (the default).}

\item{dist_threshold}{Numeric. Distance weight to prevent overweight of data
nearby
(0 to 1). Default is 0.1}

\item{R_range}{Numeric value or vector specifying the search radius (in km).
Default is \code{seq(50, 1000, 50)}}

\item{...}{optional arguments to \code{\link[=dist_greatcircle]{dist_greatcircle()}}}
}
\value{
\code{sf} object containing
\describe{
\item{lon,lat}{longitude and latitude in degrees}
\item{azi}{Mean SHmax in degree}
\item{sd}{Standard deviation of SHmax in degrees}
\item{R}{Search radius in km}
\item{mdr}{Mean distance of datapoints per search radius}
\item{N}{Number of data points in search radius}
}
}
\description{
Stress field and wavelength analysis using (weighted) mean/median and
standard deviation/IQR of stress data
}
\details{
Updated version of the MATLAB script "stress2grid"
}
\examples{
data("san_andreas")
stress2grid(san_andreas)
}
\references{
Ziegler, M. O. and Heidbach, O. (2019).
Matlab Script Stress2Grid v1.1. GFZ Data Services. \doi{10.5880/wsm.2019.002}
}
\seealso{
\code{\link[=dist_greatcircle]{dist_greatcircle()}}, \code{\link[=PoR_stress2grid]{PoR_stress2grid()}}, \code{\link[=compact_grid]{compact_grid()}},
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_median]{circular_median()}}, \code{\link[=circular_sd]{circular_sd()}}
}
