% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_a_gee.R
\name{template_a_gee}
\alias{template_a_gee}
\title{Template for Generalized Estimating Equations (GEE) analysis module}
\usage{
template_a_gee(
  output_table,
  data_model_fit = "ANL",
  dataname_lsmeans = "ANL_ADSL",
  input_arm_var = "ARM",
  ref_group = "A: Drug X",
  aval_var,
  id_var,
  arm_var,
  visit_var,
  split_covariates,
  cor_struct,
  conf_level = 0.95,
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{output_table}{(\code{character})\cr type of output table (\verb{"t_gee_cov", "t_gee_coef", "t_gee_lsmeans"}).}

\item{data_model_fit}{(\code{character})\cr dataset used to fit the model by \code{tern.gee::fit_gee()}.}

\item{dataname_lsmeans}{(\code{character})\cr dataset used for \code{alt_counts_df} argument of \code{rtables::build_table()}.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{id_var}{(\code{character})\cr the variable name for subject id.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{visit_var}{(\code{character})\cr variable names that can be used as \code{visit} variable. Must be a factor in
\code{dataname}.}

\item{split_covariates}{(\code{character})\cr vector of names of variables to use as covariates in
\code{tern.gee::vars_gee()}.}

\item{cor_struct}{(\code{character})\cr assumed correlation structure in \code{tern.gee::fit_gee}.}

\item{conf_level}{(\code{numeric})\cr value for the confidence level within the range of (0, 1).}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate an analysis table using Generalized Estimating Equations (GEE).
}
\seealso{
\code{\link[=tm_a_gee]{tm_a_gee()}}
}
\keyword{internal}
