% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_therapy.R
\name{tm_g_pp_therapy}
\alias{tm_g_pp_therapy}
\title{teal Module: Patient Profile Therapy Table and Plot}
\usage{
tm_g_pp_therapy(
  label,
  dataname = "ADCM",
  parentname = "ADSL",
  patient_col = "USUBJID",
  atirel = NULL,
  cmdecod = NULL,
  cmindc = NULL,
  cmdose = NULL,
  cmtrt = NULL,
  cmdosu = NULL,
  cmroute = NULL,
  cmdosfrq = NULL,
  cmstdy = NULL,
  cmendy = NULL,
  font_size = c(12L, 12L, 25L),
  plot_height = c(700L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{atirel}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{ATIREL} variable from \code{dataname}.}

\item{cmdecod}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDECOD} variable from \code{dataname}.}

\item{cmindc}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMINDC} variable from \code{dataname}.}

\item{cmdose}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDOSE} variable from \code{dataname}.}

\item{cmtrt}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMTRT} variable from \code{dataname}.}

\item{cmdosu}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDOSU} variable from \code{dataname}.}

\item{cmroute}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMROUTE} variable from \code{dataname}.}

\item{cmdosfrq}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDOSFRQ} variable from \code{dataname}.}

\item{cmstdy}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMSTDY} variable from \code{dataname}.}

\item{cmendy}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMENDY} variable from \code{dataname}.}

\item{font_size}{(\code{numeric})\cr numeric vector of length 3 of current, minimum and maximum font size values.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a patient profile therapy table and \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type plot using ADaM datasets.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators::
\itemize{
\item \code{plot} (\code{ggplot})
\item \code{table} (\code{datatables} - output of \code{DT::datatable()})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_pp_therapy(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...), # applied only to `plot` output
     table = teal_transform_module(...) # applied only to `table` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(nestcolor)
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADCM <- tmc_ex_adcm
  ADSL <- tmc_ex_adsl \%>\% filter(USUBJID \%in\% ADCM$USUBJID)
  ADCM$CMASTDTM <- ADCM$ASTDTM
  ADCM$CMAENDTM <- ADCM$AENDTM
})

join_keys(data) <- default_cdisc_join_keys[c("ADSL", "ADCM")]
adcm_keys <- c("STUDYID", "USUBJID", "ASTDTM", "CMSEQ", "ATC1", "ATC2", "ATC3", "ATC4")
join_keys(data)["ADCM", "ADCM"] <- adcm_keys

ADSL <- data[["ADSL"]]
ADCM <- data[["ADCM"]]

app <- init(
  data = data,
  modules = modules(
    tm_g_pp_therapy(
      label = "Therapy",
      dataname = "ADCM",
      parentname = "ADSL",
      patient_col = "USUBJID",
      plot_height = c(600L, 200L, 2000L),
      atirel = choices_selected(
        choices = variable_choices(ADCM, "ATIREL"),
        selected = c("ATIREL")
      ),
      cmdecod = choices_selected(
        choices = variable_choices(ADCM, "CMDECOD"),
        selected = "CMDECOD"
      ),
      cmindc = choices_selected(
        choices = variable_choices(ADCM, "CMINDC"),
        selected = "CMINDC"
      ),
      cmdose = choices_selected(
        choices = variable_choices(ADCM, "CMDOSE"),
        selected = "CMDOSE"
      ),
      cmtrt = choices_selected(
        choices = variable_choices(ADCM, "CMTRT"),
        selected = "CMTRT"
      ),
      cmdosu = choices_selected(
        choices = variable_choices(ADCM, "CMDOSU"),
        selected = c("CMDOSU")
      ),
      cmroute = choices_selected(
        choices = variable_choices(ADCM, "CMROUTE"),
        selected = "CMROUTE"
      ),
      cmdosfrq = choices_selected(
        choices = variable_choices(ADCM, "CMDOSFRQ"),
        selected = "CMDOSFRQ"
      ),
      cmstdy = choices_selected(
        choices = variable_choices(ADCM, "ASTDY"),
        selected = "ASTDY"
      ),
      cmendy = choices_selected(
        choices = variable_choices(ADCM, "AENDY"),
        selected = "AENDY"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACIAwgCyyTqkMARpcAAeaVD8BDD1Tc0AygAyXT19g8P8otQ6AKQAfOsmtNTkjOwOUw4AQgBSAJLNG+U7LR0AJMdnV81BDQ-tjx2NU7bNWydfJfR5-AFAiag35OABygOBRlBjThCKUAF8gkoAFZEcppADWcFYokqiRs+X4cGMUGEpDSBH4tFEfVx+KJJOABHYCjALVmvJqvK+vLkAF0lCMxoTiaIutzef8HM0AJrXQU6XkvC7qvCavn-NF63kdKZOACKGuFtlaAEYrXybQAmB2NG0AZldNoALKKcXiIDKSWSoHJgMK2u1XZHeWKulKYEHRLF+XNKVVgOG+dMZrGJRAvl1cpmIx087E0KguuVijyIA1cjoALw6XK4CZ8IQiOUtzvCMR1hoNHppADmaXQaVKqjQHAmQ501Cg9DgaxbvNsJRnqFYgvnQ9y0Hgzf1Irw+4aqBYFFIR906+zAvP9YXOivGhvDKIa-12ree5fBdIiIekt1oUcSlIE9uQANgABjgmYaidBCkJ0FDULkdtAKHBJaEYVdoJKPECDENJRFXOB1DgfhB1fBoCGImQxBPTQWFoZcRAZJjSNJL4hUdS4sCcXMwCwi8hwokRqP4aCeUE4TRI+V9xJwhiYCpYhZJbRiSLIqSqPIWiJIYniWJbNjGA4+guN05i+MjASOmaJxWgAeWaUVsPohoDJkk8TXaFz3M8sAJNU+ixnKUYiL00RyMomS6Misyex0SzrNs1L2H4-UOkueFWi8kydD8oyArAfLCt5cLvNfMZ+CICjYvshLpKM5L6tS1j2M4uBuLinLHLyoK3LNYq1MkxLyofZyxpcMLJoi+qYFIRgoJ01K2sMmjOoXOzeJ6qy+oG+yho6Jz2nsWwJp80rppoiqOmumqlrq-aNKawQWt47akpKg7zPS3qbP6wGHIukbmjGhxbp8srHp0+S5pOP03oksZGCIQRyB+-SHuMybTLio7MrB7LcsCrA3IcWwFuW+iEe0kbqdphbaoxz7RGMRgAEc8fipm9qHcHSZO8HzvaS7oamAAxLBLTE97XyZp7RrlhXXvohmRZgURSH4VgBb+jqAe6iyQaywbKYNAEVThxmCYq8FVS1lTlfUihDeNoWzZJi3jtB07eMlgSUXhe2lZK1WH3D13Fu1-dlKCIJaGMHR2HKA4oAsbRrBsOoX1EMoIFYRp0HYStHkEWgairijGG0GIIHRJQwHRMUgA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACIAwgCyyTqkMARpcAAeaVD8BDD1Tc0AygAyXT19g8P8otQ6AKQAfOsmtNTkjOwOUw4AQgBSAJLNG+U7LR0AJMdnV81BDQ-tjx2NU7bNWydfJfR5-AFAiag35OABygOBRlBjThCKUAF8gkoAFZEcppADWcFYokqiRs+X4cGMUGEpDSBH4tFEfVx+KJJOABHYCjALVmvJqvK+vLkAF0lCMxoTiaIutzef8HM0AJrXQU6XkvC7qvCavn-NF63kdKZOACKGuFtlaAEYrXybQAmB2NG0AZldNoALKKcXiIDKSWSoHJgMK2u1XZHeWKulKYEHRLF+XNKVVgOG+dMZrGJRAvl1cpmIx087E0KguuVijyIA1cjoALw6XK4CZ8IQiOUtzvCMR1hoNHppADmaXQaVKqjQHAmQ501Cg9DgaxbvNsJRnqFYgvnQ9y0Hgzf1Irw+4aqBYFFIR906+zAvP9YXOivGhvDKIa-12ree5fBdIiIekt1oUcSlIE9uQANgABjgmYaidBCkJ0FDULkdtAKHBJaEYVdoJKPECDENJRFXOB1DgfhB1fBoCGImQxBPTQWFoZcRAZJjSNJL4hUdS4sCcXMwCwi8hwokRqP4aCeUE4TRI+V9xJwhiYCpYhZJbRiSLIqSqPIWiJIYniWJbNjGA4+guN05i+MjASOmaJxWgAeWaUVsPohoDJkk8TXaFz3M8sAJNU+ixnKUYiL00RyMomS6Misyex0SzrNs1L2H4-UOkueFWi8kydD8oyArAfLCt5cLvNfMZ+CICjYvshLpKM5L6tS1j2M4uBuLinLHLyoK3LNYq1MkxLyofZyxpcMLJoi+qYFIRgoJ01K2sMmjOoXOzeJ6qy+oG+yho6Jz2nsWwJp80rppoiqOmumqlrq-aNKawQWt47akpKg7zPS3qbP6wGHIukbmjGhxbp8srHp0+S5pOP03oksZGCIQRyB+-SHuMybTLio7MrB7LcsCrA3IcWwFuW+iEe0kbqdphbaoxz7RGMRgAEc8fipm9qHcHSZO8HzvaS7oamAAxLBLTE97XyZp7RrlhXXvohmRZgURSH4VgBb+jqAe6iyQaywbKYNAEVThxmCYq8FVS1lTlfUihDeNoWzZJi3jtB07eMlgSUXhe2lZK1WH3D13Fu1-dlKCIJaGMHR2HKA4oAsbRrBsOoX1EMoIFYRp0HYStHkEWgairijGG0GIIHRJQwHRMUgA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

