% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_f.R
\name{get.seq}
\alias{get.seq}
\title{Generates a Sequence from a Range of Frequency}
\usage{
get.seq(from, to, by = 1)
}
\arguments{
\item{from}{First frequency of the range.}

\item{to}{Last frequency of the range.}

\item{by}{An integer that determines the increment of the sequence.}
}
\value{
A list of characters that represents the sequence.
}
\description{
Use it to generate a list of characters, where each element is a string representation of a frequency within the specified range.
}
\details{
The two arguments \code{from} and \code{to} should be a valid frequencies (see \code{f.?} methods).
Also, they should be consistent. You cannot create a sequence in which one is e.g. monthly, and the other is yearly.
}
\examples{
from <- f.monthly(2020,1)
to <- f.monthly(2021,12)
sequence1 <- get.seq(from, to, 1) # this will be '2020M1', '2020M2', ..., '2021M12'
sequence2 <- get.seq(from, to, 2) # this will be '2020M1', '2020M3', ..., '2021M11'
sequence3 <- get.seq(from, to, 3) # this will be '2020M1', '2020M4', ..., '2021M10'

# backward:
sequence4 <- get.seq(to, from, -1) # this will be '2021M12', '2021M11', ..., '2020M1'

}
\seealso{
\code{\link{get.seq0}}
}
