% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.daily}
\alias{f.daily}
\title{Creates a Daily Frequency}
\usage{
f.daily(year, month, day, dateString = NULL, asDateFun = NULL)
}
\arguments{
\item{year}{Year of the observation. It should be a valid year as an integer.}

\item{month}{Month of the observation. It should be a valid month of year as an integer.}

\item{day}{Day of the observation. It should be a valid day of month as an integer.}

\item{dateString}{A string that represents a date. If not \code{NULL}, this will be used instead of \code{year}, \code{month}, and \code{day}, and they can be omitted.}

\item{asDateFun}{If \code{dateString} is given, you can use it to convert the string to a \code{Date}. If \code{NULL}, default conversion is used.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{year} \tab Determines the \code{year}.\cr
\code{month} \tab Determines the \code{month}.\cr
\code{day} \tab Determines the \code{day}.
}
}
\description{
Use it to create a frequency for time-series data that occurs daily.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"YYYYMMDD"} (similar to \code{Weekly})
\item \strong{Class Id} \code{"d"}
}
}
\examples{

d0 <- f.daily(2023, 1, 2) # This is 2/1/2023. Next observation belongs to 3/1/2023.

d0_value_str <-  as.character(d0) # this will be '20230102'.
d0_class_str <- get.class.id(d0) # this will be 'd'.

d_new <- as.frequency("20230109", "d") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
# d_invalid <- try(as.frequency("1399109", "d")) # this is a too old date and unsupported
# d_invalid <- try(as.frequency("20230132", "d")) # invalid day in month
d_invalid <- try(as.frequency("20231331", "d")) # invalid month
}

}
