% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_hyperlink.R
\name{make_hyperlink}
\alias{make_hyperlink}
\title{Create a hyperlink to display as a link on a tableHTML}
\usage{
make_hyperlink(vec, message = NULL)
}
\arguments{
\item{vec}{A vector. Typically the column of a data.frame.}

\item{message}{The hyperlinks name. If it is omitted, the actual link will
be used as the name}
}
\value{
A character vector which will represent an HTML hyperlink
}
\description{
\code{make_hyperlink} add the relevant <a> tag on a vector.
}
\details{
\code{make_hyperlink} The standard way to use this (although it can be used
  outside a tableHTML) is to convert a column with plain URLs into 
  clickable hyperlinks when you render the HTML table. **Make sure 
  the escape argument of tableHTML is set to FALSE for this to work as 
  expected.**
}
\examples{
#make sure the escape argument is set to FALSE for this to work
tableHTML(data.frame(mpg = make_hyperlink(mtcars$mpg)), escape = FALSE)

tableHTML(data.frame(mpg = make_hyperlink(mtcars$mpg, 1:32)), escape = FALSE)

}
