% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{loadVectorJson}
\alias{loadVectorJson}
\title{Load a vector from json}
\usage{
loadVectorJson(json_object, json_vector_label, subfolder_name = NULL)
}
\arguments{
\item{json_object}{Object of class \code{CppJson}}

\item{json_vector_label}{Label referring to a particular vector (i.e. "sigma2_samples") in the overall json hierarchy}

\item{subfolder_name}{(Optional) Name of the subfolder / hierarchy under which vector sits}
}
\value{
R vector
}
\description{
Load a vector from json
}
\examples{
example_vec <- runif(10)
example_json <- createCppJson()
example_json$add_vector("myvec", example_vec)
roundtrip_vec <- loadVectorJson(example_json, "myvec")
}
