% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{basis_guided}
\alias{basis_guided}
\title{Solve for the last basis of a guided tour.}
\usage{
basis_guided(data, index_f = tourr::holes(), d = 2, ...)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations.}

\item{index_f}{The index function to optimize.
\code{{tourr}} exports \code{holes()}, \code{cmass()}, and \code{lda_pp(class)}.}

\item{d}{Number of dimensions in the projection space.}

\item{...}{Optional, other arguments to pass to
\code{\link[tourr:guided_tour]{tourr::guided_tour}}}
}
\value{
Numeric matrix of the last basis of a guided tour.
}
\description{
Performs simulated annealing on the index function, solving for it's local
extrema. Returns only the last identified basis of the optimization. A
truncated, muted extension of tourr::save_history(guided_tour())).
}
\examples{
dat <- scale_sd(wine[, 2:6])
basis_guided(data = dat, index_f = tourr::holes())

basis_guided(data = dat, index_f = tourr::cmass(),
             alpha = .4, cooling = .9, max.tries = 10, n_sample = 4)
}
\seealso{
\code{\link[tourr:guided_tour]{tourr::guided_tour}} for annealing
arguments.

Other basis producing functions: 
\code{\link{basis_half_circle}()},
\code{\link{basis_odp}()},
\code{\link{basis_olda}()},
\code{\link{basis_onpp}()},
\code{\link{basis_pca}()}
}
\concept{basis producing functions}
