% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mem.R
\name{mem}
\alias{mem}
\title{Moran's Eigenvector Maps of a distance matrix}
\usage{
mem(
  distance.matrix = NULL,
  distance.threshold = 0,
  colnames.prefix = "mem"
)
}
\arguments{
\item{distance.matrix}{Distance matrix. Default: \code{NULL}.}

\item{distance.threshold}{Numeric vector with distance thresholds defining different neighborhood extents within the distance matrix, Default: 0}

\item{colnames.prefix}{Character, name prefix for the output columns. Default: \code{"mem"}}
}
\value{
A data frame with positive Moran's Eigenvector Maps.
}
\description{
Computes the positive Moran's Eigenvector Maps of a distance matrix.
}
\details{
Takes the distance matrix \code{x}, double-centers it with \code{\link[=double_center_distance_matrix]{double_center_distance_matrix()}}, applies \link[base]{eigen}, and returns eigenvectors with positive normalized eigenvalues (a.k.a Moran's Eigenvector Maps, or MEMs). These MEMs are later used as spatial predictors by \code{\link[=rf_spatial]{rf_spatial()}}.
}
\examples{
if(interactive()){

 #loading example distance matrix
 data(distance_matrix)

 #Moran's Eigenvector Maps of the distance matrix
 mem <- mem(x = distance_matrix)

}
}
\seealso{
\code{\link[=mem_multithreshold]{mem_multithreshold()}}, \code{\link[=rf_spatial]{rf_spatial()}}
}
