% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_seq.R
\name{date.seq}
\alias{date.seq}
\title{date sequence}
\usage{
date.seq(
  start,
  end,
  step = c("day", "week", "month", "quarter", "year", "minute"),
  rm.leap = FALSE
)
}
\arguments{
\item{start}{Start date in "yyyy/mm/dd" character format}

\item{end}{End date in "yyyy/mm/dd" character format}

\item{step}{Time step, options are c("day", "week", "month", "quarter", 
"year", "minute")}

\item{rm.leap}{Remove extra days in leap years}
}
\value{
A date vector of class POSIXct for minute and Date for other options
}
\description{
creates date sequence given start and stop dates
}
\details{
Please note that this is not a memory safe function that utilizes
rasters out of memory in the manner that the raster package does.
}
\examples{
# monthly steps 1990/01/01 - 2019/12/31
d <- date.seq("1990/01/01", "2019/12/31", step="month")

# daily steps 1990/01/01 - 2019/12/31
d <- date.seq("1990/01/01", "2019/12/31", step="day")

# daily steps 1990/01/01 - 2019/12/31 with leap days removed
d <- date.seq("1990/01/01", "2019/12/31", step="day", rm.leap=TRUE)

# daily step 2008/12/29 - 2008/12/31, 2008 is leap year
d <- date.seq("2008/12/29", "2008/12/31")

# minutes step 2008/12/29 - 2008/12/31, 2008 is leap year
d <- date.seq("2008/12/29", "2008/12/31", step="minute")

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
