% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_set.R
\name{basis2mrs_data}
\alias{basis2mrs_data}
\title{Convert a basis object to an mrs_data object - where basis signals are spread
across the dynamic dimension.}
\usage{
basis2mrs_data(
  basis,
  sum_elements = FALSE,
  amps = NULL,
  shifts = NULL,
  lbs = NULL
)
}
\arguments{
\item{basis}{basis set object.}

\item{sum_elements}{return the sum of basis elements (logical)}

\item{amps}{a vector of scaling factors to apply to each basis element.}

\item{shifts}{a vector of frequency shifts (in ppm) to apply to each basis
element.}

\item{lbs}{a vector of Lorentzian line broadening terms (in Hz) to apply to
each basis element.}
}
\value{
an mrs_data object with basis signals spread across the dynamic
dimension or summed.
}
\description{
Convert a basis object to an mrs_data object - where basis signals are spread
across the dynamic dimension.
}
