% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackedSampler.R
\name{stackedSampler}
\alias{stackedSampler}
\title{Sample from the stacked posterior distribution}
\usage{
stackedSampler(mod_out, n.samples)
}
\arguments{
\item{mod_out}{an object that is an output of a model fit or a prediction
task, i.e., the class should be either \code{spLMstack}, 'pp.spLMstack',
\code{spGLMstack}, \code{pp.spGLMstack}, \code{stvcGLMexact}, or \code{pp.stvcGLMexact}.}

\item{n.samples}{(optional) If missing, inherits the number
of posterior samples from the original output. Otherwise, it specifies
number of posterior samples to draw from the stacked posterior. If it exceeds
the number of posterior draws used in the original function, then a message
is thrown and the samples are obtained by resampling. We recommended running
the original model fit/prediction with enough samples.}
}
\value{
An object of class \code{stacked_posterior}, which is a list that
includes the following tags -
\describe{
\item{beta}{samples of the fixed effect from the stacked joint posterior.}
\item{z}{samples of the spatial random effects from the stacked joint
posterior.}
}
The list may also include other scale parameters corresponding to the model.
}
\description{
A helper function to sample from the stacked posterior
distribution to obtain final posterior samples that can be used for
subsequent analysis. This function applies on outputs of functions
\code{\link[=spLMstack]{spLMstack()}} and \code{\link[=spGLMstack]{spGLMstack()}}.
}
\details{
After obtaining the optimal stacking weights
\eqn{\hat{w}_1, \ldots, \hat{w}_G}, posterior inference of quantities of
interest subsequently proceed from the \emph{stacked} posterior,
\deqn{
\tilde{p}(\cdot \mid y) = \sum_{g = 1}^G \hat{w}_g p(\cdot \mid y, M_g),
}
where \eqn{\mathcal{M} = \{M_1, \ldots, M_g\}} is the collection of candidate
models.
}
\examples{
set.seed(1234)
data(simGaussian)
dat <- simGaussian[1:100, ]

mod1 <- spLMstack(y ~ x1, data = dat,
                  coords = as.matrix(dat[, c("s1", "s2")]),
                  cor.fn = "matern",
                  params.list = list(phi = c(1.5, 3),
                                     nu = c(0.5, 1),
                                     noise_sp_ratio = c(1)),
                  n.samples = 1000, loopd.method = "exact",
                  parallel = FALSE, solver = "ECOS", verbose = TRUE)
print(mod1$solver.status)
print(mod1$run.time)

post_samps <- stackedSampler(mod1)
post_beta <- post_samps$beta
print(t(apply(post_beta, 1, function(x) quantile(x, c(0.025, 0.5, 0.975)))))
}
\seealso{
\code{\link[=spLMstack]{spLMstack()}}, \code{\link[=spGLMstack]{spGLMstack()}}
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
