% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permtest.smacofP.R
\name{permtest.smacofP}
\alias{permtest.smacofP}
\title{Permutation test for smacofP objects}
\usage{
\method{permtest}{smacofP}(
  object,
  data,
  method.dat = "pearson",
  nrep = 100,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class smacofP if used as method or another object inheriting from smacof (needs to be called directly as permtest.smacofP then).}

\item{data}{Optional: Initial data; if provided permutations are performed on the data matrix (see details)}

\item{method.dat}{Dissimilarity computation used as MDS input. This must be one of "pearson", "spearman", "kendall", "euclidean", "maximum", "manhattan", "canberra", "binary". If data is provided, then this must be provided as well.}

\item{nrep}{Number of permutations.}

\item{verbose}{If TRUE, bootstrap index is printed out.}

\item{...}{Additional arguments needed for dissimilarity computation as specified in \code{\link[smacof]{sim2diss}}.}
}
\value{
An object of class 'smacofPerm', see \code{\link[smacof]{permtest}} for details and methods. It has values
\itemize{
\item stressvec: Vector containing the stress values of the permutation samples
\item stress.obs: Stress (observed sample) 
\item pval: Resulting p-value
\item call: Model call
\item nrep: Number of permutations
\item nobj: Number of objects
}
}
\description{
Performs a permutation test on an MDS solution. It works with a smacofP object alone and also for derived dissimilarities, i.e. generated by the call dist(data). The original data matrix needs to be provided, as well as the type of dissimilarity measure used to compute the input dissimilarities.
}
\details{
This routine permutes m dissimilarity values, where m is the number of lower diagonal
elements in the corresponding dissimilarity matrix. For each sample a symmetric, nonmetric SMACOF of
dimension 'ndim' is computed and the stress values are stored in ‘stressvec’. Using the fitted
stress value, the p-value is computed. Subsequently, the empirical cumulative distribution function
can be plotted using the plot method.

If the MDS fit provided on derived proximities of a data matrix,
this matrix can be passed to the ‘permtest’ function.
Consequently, the data matrix is subject to permutations. The
proximity measure used for MDS fit has to match the one used for
the permutation test. If a correlation similarity is provided, it
is converted internally into a dissimilarity using 'sim2diss' with
corresponding arguments passed to the ... argument.
}
\examples{
##see ?smacof::permtest for more
## permuting the dissimilarity matrix (full)
#' data(kinshipdelta)
fitkin <- rStressMin(kinshipdelta, ndim = 2, r=0.5,itmax=10) #use higher itmax
set.seed(222)
res.perm <- permtest(fitkin,nrep=5) #use higher nrep in reality
res.perm
plot(res.perm)
## permuting the data matrix
GOPdtm[GOPdtm > 1] <- 1     ## use binary version
diss1 <- dist(t(GOPdtm[,1:10]), method = "binary")  ## Jaccard distance
fitgop1 <- alscal(diss1,type="interval",itmax=10) #use higher itmax
fitgop1
set.seed(123)
permtest(fitgop1, GOPdtm[,1:10], nrep = 5, method.dat = "binary")
}
