% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_semanaepi}
\alias{agrupar_semanaepi}
\title{Agrupar por semana epidemiológica y casos}
\usage{
agrupar_semanaepi(data_event, col_semanaepi = "semana")
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de
una enfermedad o evento.}

\item{col_semanaepi}{Un `character` (cadena de caracteres)
con el nombre de la columna que contiene las semanas
epidemiológicas en los datos de la enfermedad o evento;
su valor por defecto es `"semana"`.}
}
\value{
Un `data.frame` con los datos de una enfermedad o
evento agrupados por semana epidemiológica y número de casos.
}
\description{
Función que agrupa los datos de una enfermedad o evento
por semana epidemiológica y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_semanaepi(
  data_event = data_limpia,
  col_semanaepi = "semana"
)
}
