% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_patterns.R
\name{sits_patterns}
\alias{sits_patterns}
\title{Find temporal patterns associated to a set of time series}
\usage{
sits_patterns(data = NULL, freq = 8, formula = y ~ s(x), ...)
}
\arguments{
\item{data}{Time series.}

\item{freq}{Interval in days for estimates.}

\item{formula}{Formula to be applied in the estimate.}

\item{...}{Any additional parameters.}
}
\value{
Time series with patterns.
}
\description{
This function takes a set of time series samples as input
estimates a set of patterns. The patterns are calculated using a GAM model.
The idea is to use a formula of type y ~ s(x), where x is a temporal
reference and y if the value of the signal. For each time, there will
be as many predictions as there are sample values.
The GAM model predicts a suitable
approximation that fits the assumptions of the statistical model,
based on a smooth function.

This method is based on the "createPatterns" method of the dtwSat package,
which is also described in the reference paper.
}
\examples{
if (sits_run_examples()) {
    patterns <- sits_patterns(cerrado_2classes)
    plot(patterns)
}

}
\references{
Maus V, Camara G, Cartaxo R, Sanchez A, Ramos F, Queiroz GR.
A Time-Weighted Dynamic Time Warping Method for Land-Use
and Land-Cover Mapping. IEEE Journal of Selected Topics in Applied
Earth Observations and Remote Sensing, 9(8):3729-3739,
August 2016. ISSN 1939-1404. doi:10.1109/JSTARS.2016.2517118.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
