% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-lin-sde-mean.R
\name{LinSDEMean}
\alias{LinSDEMean}
\title{Steady-State Mean Vector for the
Linear Stochastic Differential Equation Model}
\usage{
LinSDEMean(phi, iota)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix
which represents the rate of change of the solution
in the absence of any random fluctuations
(\eqn{\boldsymbol{\Phi}}).}

\item{iota}{Numeric vector.
An unobserved term that is constant over time
(\eqn{\boldsymbol{\iota}}).}
}
\description{
The steady-state mean vector is given by
\deqn{
  -\boldsymbol{\Phi}^{-1} \boldsymbol{\iota}
}.
}
\examples{
iota <- c(0.317, 0.230)
phi <- matrix(
  data = c(
    -0.10,
    0.05,
    0.05,
    -0.10
  ),
  nrow = 2
)
LinSDEMean(phi = phi, iota = iota)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECov}()},
\code{\link{SimBetaN}()},
\code{\link{SimPhiN}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestPhi}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{sim}
\keyword{simStateSpace}
