% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtual-select.R
\name{prepare_choices}
\alias{prepare_choices}
\title{Prepare choices for \code{\link[=virtualSelectInput]{virtualSelectInput()}}}
\usage{
prepare_choices(
  .data,
  label,
  value,
  group_by = NULL,
  description = NULL,
  alias = NULL
)
}
\arguments{
\item{.data}{An object of type \code{\link[=data.frame]{data.frame()}}.}

\item{label}{Variable to use as labels (displayed to user).}

\item{value}{Variable to use as values (retrieved server-side).}

\item{group_by}{Variable identifying groups to use option group feature.}

\item{description}{Optional variable allowing to show a text under the labels.}

\item{alias}{Optional variable containing text to use with search feature.}
}
\value{
A \code{list} to use as \code{choices} argument of \code{\link[=virtualSelectInput]{virtualSelectInput()}}.
}
\description{
Prepare choices for \code{\link[=virtualSelectInput]{virtualSelectInput()}}
}
\examples{
library(shiny)
library(shinyWidgets)

state_data <- data.frame(
  name = state.name,
  abb = state.abb,
  region = state.region,
  division = state.division
)

ui <- fluidPage(
  tags$h2("Virtual Select: prepare choices"),

  virtualSelectInput(
    inputId = "sel1",
    label = "Use a data.frame:",
    choices = prepare_choices(state_data, name, abb),
    search = TRUE
  ),
  verbatimTextOutput("res1"),

  virtualSelectInput(
    inputId = "sel2",
    label = "Group choices:",
    choices = prepare_choices(state_data, name, abb, region),
    multiple = TRUE
  ),
  verbatimTextOutput("res2"),

  virtualSelectInput(
    inputId = "sel3",
    label = "Add a description:",
    choices = prepare_choices(state_data, name, abb, description = division),
    multiple = TRUE,
    hasOptionDescription = TRUE
  ),
  verbatimTextOutput("res3")
)

server <- function(input, output, session) {
  output$res1 <- renderPrint(input$sel1)
  output$res2 <- renderPrint(input$sel2)
  output$res3 <- renderPrint(input$sel3)
}

if (interactive())
  shinyApp(ui, server)

}
