% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jitter.R
\name{st_jitter}
\alias{st_jitter}
\title{jitter geometries}
\usage{
st_jitter(x, amount, factor = 0.002)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}}

\item{amount}{numeric; amount of jittering applied; if missing, the amount is set to factor * the bounding box diagonal; units of coordinates.}

\item{factor}{numeric; fractional amount of jittering to be applied}
}
\description{
jitter geometries
}
\details{
jitters coordinates with an amount such that \code{runif(1, -amount, amount)} is added to the coordinates. x- and y-coordinates are jittered independently but all coordinates of a single geometry are jittered with the same amount, meaning that the geometry shape does not change. For longlat data, a latitude correction is made such that jittering in East and North directions are identical in distance in the center of the bounding box of \code{x}.
}
\examples{
nc = st_read(system.file("gpkg/nc.gpkg", package="sf"))
pts = st_centroid(st_geometry(nc))
plot(pts)
plot(st_jitter(pts, .05), add = TRUE, col = 'red')
plot(st_geometry(nc))
plot(st_jitter(st_geometry(nc), factor = .01), add = TRUE, col = '#ff8888')
}
