% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mnhmm.R
\name{estimate_mnhmm}
\alias{estimate_mnhmm}
\title{Estimate a Mixture Non-homogeneous Hidden Markov Model}
\usage{
estimate_mnhmm(
  n_states,
  n_clusters,
  emission_formula,
  initial_formula = ~1,
  transition_formula = ~1,
  cluster_formula = ~1,
  data,
  time,
  id,
  lambda = 0,
  prior_obs = "fixed",
  state_names = NULL,
  cluster_names = NULL,
  inits = "random",
  init_sd = 2,
  restarts = 0L,
  method = "EM-DNM",
  bound = Inf,
  control_restart = list(),
  control_mstep = list(),
  ...
)
}
\arguments{
\item{n_states}{An integer > 1 defining the number of hidden states.}

\item{n_clusters}{A positive integer defining the number of clusters
(mixtures).}

\item{emission_formula}{of class \code{\link[=formula]{formula()}} for the
state emission probabilities, or a list of such formulas in case of multiple
response variables. The left-hand side of formulas define the responses.
For multiple responses having same formula, you can use a form
\code{c(y1, y2) ~ x}, where \code{y1} and \code{y2} are the response variables.}

\item{initial_formula}{of class \code{\link[=formula]{formula()}} for the
initial state probabilities. Left-hand side of the formula should be empty.}

\item{transition_formula}{of class \code{\link[=formula]{formula()}} for the state transition
probabilities. Left-hand side of the formula should be empty.}

\item{cluster_formula}{of class \code{\link[=formula]{formula()}} for the mixture probabilities.}

\item{data}{A data frame containing the variables used in the model
formulas.}

\item{time}{Name of the time index variable in \code{data}.}

\item{id}{Name of the id variable in \code{data} identifying different
sequences.}

\item{lambda}{Penalization factor \code{lambda} for penalized log-likelihood, where the
penalization is \code{0.5 * lambda * sum(eta^2)}. Note that with
\code{method = "L-BFGS"} both objective function (log-likelihood) and
the penalization term is scaled with number of non-missing observations.
Default is \code{0}, but small values such as \code{1e-4} can help to ensure numerical
stability of L-BFGS by avoiding extreme probabilities. See also argument
\code{bound} for hard constraints.}

\item{prior_obs}{Either \code{"fixed"} or a list of vectors given the prior
distributions for the responses at time "zero". See details.}

\item{state_names}{A vector of optional labels for the hidden states. If this
is \code{NULL} (the default), numbered states are used.}

\item{cluster_names}{A vector of optional labels for the clusters. If this
is \code{NULL} (the default), numbered clusters are used.}

\item{inits}{If \code{inits = "random"} (default), random initial values are
used. Otherwise \code{inits} should be list of initial values. If coefficients
are given using list components \code{eta_pi}, \code{eta_A}, \code{eta_B},
and \code{eta_omega}, these are used as is, alternatively initial values
can be given in terms of the initial state, transition, emission, and mixture
probabilities using list components \code{initial_probs}, \code{emission_probs},
\code{transition_probs}, and \code{cluster_probs}. These can also be mixed, i.e. you
can give only \code{initial_probs} and \code{eta_A}.}

\item{init_sd}{Standard deviation of the normal distribution used to generate
random initial values. Default is \code{2}. If you want to fix the initial values
of the regression coefficients to zero, use \code{init_sd = 0}.}

\item{restarts}{Number of times to run optimization using random starting
values (in addition to the final run). Default is 0.}

\item{method}{Optimization method used. Option \code{"EM"} uses EM
algorithm with L-BFGS in the M-step. Option \code{"DNM"} uses
direct maximization of the log-likelihood, by default using L-BFGS. Option
\code{"EM-DNM"} (the default) runs first a maximum of 10 iterations of EM and
then switches to L-BFGS (but other algorithms of NLopt can be used).}

\item{bound}{Positive value defining the hard lower and upper bounds for the
working parameters \eqn{\eta}, which are used to avoid extreme probabilities and
corresponding numerical issues especially in the M-step of EM algorithm.
Default is \verb{Inf´, i.e., no bounds. Note that he bounds are not enforced  for M-step in intercept-only case with }lambda = 0`.}

\item{control_restart}{Controls for restart steps, see details.}

\item{control_mstep}{Controls for M-step of EM algorithm, see details.}

\item{...}{Additional arguments to \code{\link[nloptr:nloptr]{nloptr::nloptr()}} and EM algorithm.
See details.}
}
\value{
Object of class \code{mnhmm}.
}
\description{
Function \code{estimate_mnhmm} estimates a mixture version of
non-homogeneous hidden Markov model (MNHMM) where initial, transition,
emission, and mixture probabilities can depend on covariates. See
\code{\link[=estimate_nhmm]{estimate_nhmm()}} for further details.
}
\examples{
data("mvad", package = "TraMineR")

d <- reshape(mvad, direction = "long", varying = list(15:86), 
  v.names = "activity")

\dontrun{
set.seed(1)
fit <- estimate_mnhmm(n_states = 3, n_clusters = 2,
  data = d, time = "time", id = "id", 
  cluster_formula = ~ male + catholic + gcse5eq + Grammar + 
    funemp + fmpr + livboth + Belfast +
  N.Eastern + Southern + S.Eastern + Western,
  emission_formula = activity ~ male + catholic + gcse5eq,
  initial_formula = ~ 1, 
  transition_formula = ~ male + gcse5eq
  )
}
}
\seealso{
\code{\link[=estimate_nhmm]{estimate_nhmm()}} for further details.
}
