% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.nhmm}
\alias{coef.nhmm}
\alias{coef.mnhmm}
\title{Get the Estimated Regression Coefficients of Non-Homogeneous Hidden Markov
Models}
\usage{
\method{coef}{nhmm}(object, probs = NULL, ...)

\method{coef}{mnhmm}(object, probs = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{nhmm} or \code{mnhmm}.}

\item{probs}{Vector defining the quantiles of interest. When \code{NULL} (default),
no quantiles are computed. The quantiles are based on bootstrap samples of
coefficients, stored in \code{object$boot}.}

\item{...}{Ignored.}
}
\value{
A list of data tables with the estimated coefficients for initial,
transition, emission (separate \code{data.table} for each response), and cluster
probabilities (in case of mixture model).
}
\description{
Get the Estimated Regression Coefficients of Non-Homogeneous Hidden Markov
Models
}
