qzipf <- function(p, N, s, lower.tail = TRUE, log.p = FALSE){
  if (length(N) > 1 | length(s) > 1) stop("vectorization of parameters is not implemented")
  if (N <= 0 | s <= 0 | !is.wholenumber(N))  return(rep(NaN, length(p)))
  if(log.p) p <- exp(p)
  if(!lower.tail) p <- 1-p
  ## Ugly: just to make qzipf(1, ...) = N
  p[p==1] <- 1+1e-12
  Y <- 1:N
  X <- pzipf(Y, N=N, s=s)
  approx(x=X, y=Y, xout=p, method="constant", rule=2)$y
}
