% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\name{ManualSplit}
\alias{ManualSplit}
\title{Manually defined split}
\usage{
ManualSplit(
  levels,
  label,
  name = "manual",
  extra_args = list(),
  indent_mod = 0L,
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  label_pos = "visible",
  page_prefix = NA_character_,
  section_div = NA_character_
)
}
\arguments{
\item{levels}{(\code{character})\cr levels of the split (i.e. the children of the manual split).}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{name}{(\code{string})\cr name of the split/table/row being created. Defaults to the value of the
corresponding label, but is not required to be.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{cindent_mod}{(\code{numeric(1)})\cr the indent modifier for the content tables generated by this split.}

\item{cvar}{(\code{string})\cr the variable, if any, that the content function should accept. Defaults to \code{NA}.}

\item{cextra_args}{(\code{list})\cr extra arguments to be passed to the content function when tabulating row group
summaries.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{page_prefix}{(\code{string})\cr prefix to be appended with the split value when forcing pagination between
the children of a split/table.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}
}
\value{
A \code{ManualSplit} object.
}
\description{
Manually defined split
}
\author{
Gabriel Becker
}
