% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_plans.R
\name{redist.plot.distr_qtys}
\alias{redist.plot.distr_qtys}
\title{Plot quantities by district}
\usage{
redist.plot.distr_qtys(
  plans,
  qty,
  sort = "asc",
  geom = "jitter",
  color_thresh = NULL,
  size = 0.1,
  ref_geom,
  ref_label,
  ...
)
}
\arguments{
\item{plans}{the \code{redist_plans} object.}

\item{qty}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the
quantity of interest.}

\item{sort}{set to \code{"asc"} to sort districts in ascending order of
\code{qty} (the default), \code{"desc"} for descending order, or
\code{FALSE} or \code{"none"} for no sorting.}

\item{geom}{the \code{ggplot2} geom to use in plotting the simulated districts: either
\code{"jitter"} or \code{"boxplot"}. Can also take in a function, so long as the
function accepts \code{...}.}

\item{color_thresh}{if a number, the threshold to use in coloring the points.
Plans with quantities of interest above the threshold will be colored
differently than plans below the threshold.}

\item{size}{The dot size for \code{geom="jitter"}.}

\item{ref_geom}{The reference plan geometry type. \code{"line"} or \code{"point"}
can be passed for reasonable defaults. Can also take in a function, so long as the
function accepts \code{...}.}

\item{ref_label}{A human-readable name for the reference plan. By default
the name in the \code{plan} column is used. This can also take in a function which returns
a call to \code{ggplot2::labs()}.}

\item{...}{passed on to \code{\link[ggplot2]{geom_boxplot}}}
}
\value{
A ggplot
}
\description{
Plots a boxplot of a quantity of interest across districts, with districts
optionally sorted by this quantity. Adds reference points for each reference
plan, if applicable.
}
\section{Using \code{ggdist}}{


For custom functions in \code{geom}, we can also create more complicated things like rainclouds
using the \code{ggdist} package. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{raincloud <- function(...) \{
list(
    ggdist::stat_slab(aes(thickness = ggplot2::after_stat(pdf*n)), scale = 0.7),
   ggdist::stat_dotsinterval(side = "bottom", scale = 0.7,
                             slab_size = NA, quantiles = 200)
)
\}
}\if{html}{\out{</div>}}

These functions can be then passed to \code{geom}.
}

\examples{
library(dplyr)
data(iowa)

iowa <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05, total_pop = pop)
plans <- redist_smc(iowa, nsims = 100, silent = TRUE)
plans <- plans \%>\% mutate(pct_dem = group_frac(iowa, dem_08, tot_08))
redist.plot.distr_qtys(plans, pct_dem)

# It also takes custom functions:
redist.plot.distr_qtys(plans, pct_dem, geom = ggplot2::geom_violin)

# With the raincloud example, if you have `ggdist`, you can run:
# redist.plot.distr_qtys(plans, pct_dem, geom = raincloud)

# The reference geom can also be changed via `reg_geom`
r_geom <- function(...) ggplot2::geom_segment(ggplot2::aes(as.integer(.data$.distr_no) - 0.5,
                          xend = as.integer(.data$.distr_no) + 0.5,
                          yend = pct_dem,
                          color = .data$draw),
                      linewidth = 1.2, ...)



# Finally, the `ref_label` argument can also be swapped for a function, like so:
redist.plot.distr_qtys(plans, pct_dem, geom = ggplot2::geom_violin, ref_geom = r_geom,
    ref_label = function() ggplot2::labs(color = 'Ref.'))

}
\concept{plot}
