% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_streets}
\alias{get_osm_streets}
\title{Get OpenStreetMap streets}
\usage{
get_osm_streets(aoi, crs = NULL, highway_values = NULL, force_download = FALSE)
}
\arguments{
\item{aoi}{Area of interest as sf object or bbox. Required, no default.}

\item{crs}{A numeric vector of length one with the EPSG code of the CRS}

\item{highway_values}{A character vector with the highway values to retrieve.
If left NULL, the function retrieves the following values:
"motorway", "trunk", "primary", "secondary", "tertiary"}

\item{force_download}{Download data even if cached data is available}
}
\value{
An object of class \code{\link[sf:sfc]{sf::sfc_LINESTRING}}
}
\description{
Get OpenStreetMap streets
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set parameters
bb <- get_osm_bb("Bucharest")
crs <- 31600  # National projected CRS

# Get streets with default values
get_osm_streets(aoi = bb, crs = crs)

# Specify street categories to be retrieved
get_osm_streets(aoi = bb, crs = crs, highway_values = "primary")

# Ensure that data is not retrieved from cache
get_osm_streets(aoi = bb, crs = crs, force_download = FALSE)
\dontshow{\}) # examplesIf}
}
