/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.single;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.single.SingleMapping;
import org.openscience.cdk.smsd.interfaces.AbstractMCSAlgorithm;
import org.openscience.cdk.smsd.interfaces.IMCSBase;
import org.openscience.cdk.smsd.tools.MolHandler;

@Deprecated
public class SingleMappingHandler
extends AbstractMCSAlgorithm
implements IMCSBase {
    private static List<Map<IAtom, IAtom>> allAtomMCS = null;
    private static Map<IAtom, IAtom> atomsMCS = null;
    private static Map<Integer, Integer> firstMCS = null;
    private static List<Map<Integer, Integer>> allMCS = null;
    private IAtomContainer source = null;
    private IQueryAtomContainer smartSource = null;
    private IAtomContainer target = null;
    private boolean removeHydrogen = false;

    public SingleMappingHandler(boolean removeH) {
        this.removeHydrogen = removeH;
        allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
        atomsMCS = new HashMap<IAtom, IAtom>();
        firstMCS = new TreeMap<Integer, Integer>();
        allMCS = new ArrayList<Map<Integer, Integer>>();
    }

    @Override
    public void set(MolHandler source, MolHandler target) {
        this.source = source.getMolecule();
        this.target = target.getMolecule();
    }

    @Override
    public void set(IQueryAtomContainer source, IAtomContainer target) {
        this.smartSource = source;
        this.source = source;
        this.target = target;
    }

    @Override
    public void searchMCS(boolean bondTypeMatch) {
        SingleMapping singleMapping = new SingleMapping();
        List<Map<IAtom, IAtom>> mappings = null;
        try {
            mappings = this.smartSource == null ? singleMapping.getOverLaps(this.source, this.target, this.removeHydrogen) : singleMapping.getOverLaps(this.smartSource, this.target, this.removeHydrogen);
        }
        catch (CDKException ex) {
            Logger.getLogger(SingleMappingHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setAllAtomMapping(mappings);
        this.setAllMapping(mappings);
        this.setFirstMapping();
        this.setFirstAtomMapping();
    }

    private void setAllMapping(List<Map<IAtom, IAtom>> mappings) {
        try {
            int counter = 0;
            for (Map<IAtom, IAtom> solution : mappings) {
                TreeMap<Integer, Integer> atomMappings = new TreeMap<Integer, Integer>();
                for (Map.Entry<IAtom, IAtom> map : solution.entrySet()) {
                    IAtom sourceAtom = map.getKey();
                    IAtom targetAtom = map.getValue();
                    atomMappings.put(this.source.indexOf(sourceAtom), this.target.indexOf(targetAtom));
                }
                allMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception I) {
            I.getCause();
        }
    }

    private synchronized void setAllAtomMapping(List<Map<IAtom, IAtom>> mappings) {
        try {
            int counter = 0;
            for (Map<IAtom, IAtom> solution : mappings) {
                HashMap<IAtom, IAtom> atomMappings = new HashMap<IAtom, IAtom>();
                for (Map.Entry<IAtom, IAtom> map : solution.entrySet()) {
                    IAtom sourceAtom = map.getKey();
                    IAtom targetAtom = map.getValue();
                    atomMappings.put(sourceAtom, targetAtom);
                }
                allAtomMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception I) {
            I.getCause();
        }
    }

    private synchronized void setFirstMapping() {
        if (allMCS.size() > 0) {
            firstMCS = new TreeMap<Integer, Integer>(allMCS.iterator().next());
        }
    }

    private synchronized void setFirstAtomMapping() {
        if (allAtomMCS.size() > 0) {
            atomsMCS = new HashMap<IAtom, IAtom>(allAtomMCS.iterator().next());
        }
    }

    @Override
    public List<Map<Integer, Integer>> getAllMapping() {
        return Collections.unmodifiableList(allMCS);
    }

    @Override
    public Map<Integer, Integer> getFirstMapping() {
        return Collections.unmodifiableMap(firstMCS);
    }

    @Override
    public List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return Collections.unmodifiableList(allAtomMCS);
    }

    @Override
    public Map<IAtom, IAtom> getFirstAtomMapping() {
        return Collections.unmodifiableMap(atomsMCS);
    }
}

