/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.protein.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openscience.cdk.Strand;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMonomer;

public class PDBStrand
extends Strand {
    private static final long serialVersionUID = 8278569309787734236L;
    List<String> sequentialListOfMonomers = new ArrayList<String>();

    @Override
    public void addAtom(IAtom oAtom, IMonomer oMonomer) {
        super.addAtom(oAtom, oMonomer);
        if (!this.sequentialListOfMonomers.contains(oMonomer.getMonomerName())) {
            this.sequentialListOfMonomers.add(oMonomer.getMonomerName());
        }
    }

    public Collection<String> getMonomerNamesInSequentialOrder() {
        return new ArrayList<String>(this.sequentialListOfMonomers);
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("PDBPolymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(")");
        return stringContent.toString();
    }
}

