% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{gaussW}
\alias{gaussW}
\title{Gaussian weighting of dates relative to}
\usage{
gaussW(x, mean, sd, type = "weights")
}
\arguments{
\item{x}{A numeric vector or an object of class CalDates.}

\item{mean}{A single numeric value indicating the value to centre the Gaussian kernel on.}

\item{sd}{A single numeric value indicating the standard deviation of the Gaussian kernel to be used.}

\item{type}{The type of output to produce: currently either "weighted" (for a simple total weight value for each date) or "raw" (a list of reweighted calibrated radiocarbon probabilities for each calibrated date).}
}
\value{
A numeric vector of weights (or optionally a list of reweighted calibrated radiocarbon probabilities).
}
\description{
Rescale a numeric vector to a specified minimum and maximum.
}
\examples{
## Example weighting fo a set of dates versus a focal date of 5950 calBP
years <- seq(6500, 5500, -10)
plot(cbind(years, gaussW(years, 5950, 50)))
## Example weighting of three calibrated dates  versus a focal date of 5950 calBP
dates <- calibrate(c(5280, 5180, 5080), c(30,30,30), normalised=FALSE)
gaussW(dates, 5950, 50)
## Or the same with raw output
dateswt <- gaussW(dates, 5950, 50, type="raw")
head(dateswt[[1]])
}
