% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-invoke.R
\name{invoke}
\alias{invoke}
\alias{invoke_map}
\alias{invoke_map_lgl}
\alias{invoke_map_int}
\alias{invoke_map_dbl}
\alias{invoke_map_chr}
\alias{invoke_map_raw}
\alias{invoke_map_dfr}
\alias{invoke_map_dfc}
\alias{invoke_map_df}
\title{Invoke functions.}
\usage{
invoke(.f, .x = NULL, ..., .env = NULL)

invoke_map(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_lgl(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_int(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_dbl(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_chr(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_raw(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_dfr(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_dfc(.f, .x = list(NULL), ..., .env = NULL)
}
\arguments{
\item{.f}{For \code{invoke}, a function; for \code{invoke_map} a
list of functions.}

\item{.x}{For \code{invoke}, an argument-list; for \code{invoke_map} a
list of argument-lists the same length as \code{.f} (or length 1).
The default argument, \code{list(NULL)}, will be recycled to the
same length as \code{.f}, and will call each function with no
arguments (apart from any supplied in \code{...}.}

\item{...}{Additional arguments passed to each function.}

\item{.env}{Environment in which \code{\link[=do.call]{do.call()}} should
evaluate a constructed expression. This only matters if you pass
as \code{.f} the name of a function rather than its value, or as
\code{.x} symbols of objects rather than their values.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These functions were superded in purrr 0.3.0 and deprecated in purrr 1.0.0.
\itemize{
\item \code{invoke()} is deprecated in favour of the simpler \code{exec()} function
reexported from rlang. \code{exec()} evaluates a function call built
from its inputs and supports \link[rlang:dyn-dots]{dynamic dots}:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Before:
invoke(mean, list(na.rm = TRUE), x = 1:10)

# After
exec(mean, 1:10, !!!list(na.rm = TRUE))
}\if{html}{\out{</div>}}
\item \code{invoke_map()} is deprecated because it's harder to understand than the
corresponding code using \code{map()}/\code{map2()} and \code{exec()}:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Before:
invoke_map(fns, list(args))
invoke_map(fns, list(args1, args2))

# After:
map(fns, exec, !!!args)
map2(fns, list(args1, args2), \\(fn, args) exec(fn, !!!args))
}\if{html}{\out{</div>}}
}
}
\examples{
# was
invoke(runif, list(n = 10))
invoke(runif, n = 10)
# now
exec(runif, n = 10)

# was
args <- list("01a", "01b")
invoke(paste, args, sep = "-")
# now
exec(paste, !!!args, sep = "-")

# was
funs <- list(runif, rnorm)
funs |> invoke_map(n = 5)
funs |> invoke_map(list(list(n = 10), list(n = 5)))

# now
funs |> map(exec, n = 5)
funs |> map2(list(list(n = 10), list(n = 5)), function(f, args) exec(f, !!!args))

# or use pmap + a tibble
df <- tibble::tibble(
  fun = list(runif, rnorm),
  args = list(list(n = 10), list(n = 5))
)
df |> pmap(function(fun, args) exec(fun, !!!args))


# was
list(m1 = mean, m2 = median) |> invoke_map(x = rcauchy(100))
# now
list(m1 = mean, m2 = median) |> map(function(f) f(rcauchy(100)))

}
\keyword{internal}
