% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lah_ptp.R
\name{calculate_lah_2022_extended_ptp}
\alias{calculate_lah_2022_extended_ptp}
\title{Calculate 2022 LAH Extended PTP for obstructive CAD}
\usage{
calculate_lah_2022_extended_ptp(
  age,
  sex,
  chest_pain_type,
  have_diabetes,
  have_hypertension,
  have_dyslipidemia,
  have_smoking_history,
  coronary_calcium_score
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having hypertension.
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_smoking_history}{Input characters (no, yes) to indicate if the patient
has a smoking history (current or past smoker).
\itemize{
  \item no stands for not having a smoking history (non-smoker).
  \item yes stands for having a smoking history (current or past smoker).
}}

\item{coronary_calcium_score}{Input non-negative numeric to indicate the
total coronary calcium score of the patient.}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2022 Local Assessment of the Heart (LAH) extended model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2022 Local Assessment of the Heart (LAH) extended model.
}
\details{
The predictive model is based on
patients a mixed Asian cohort within Singapore with stable chest pain.
}
\examples{
# 40 year old female with typical chest pain,
# diabetes but no hypertension, dyslipidemia,
# a non-smoker and a coronary calcium score of 0
calculate_lah_2022_extended_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical",
    have_diabetes = "yes",
    have_hypertension = "no",
    have_dyslipidemia = "no",
    have_smoking_history = "no",
    coronary_calcium_score = 0

)
}
