% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearSumPOSet.R
\name{LinearSumPOSet}
\alias{LinearSumPOSet}
\title{Linear sum of posets.}
\usage{
LinearSumPOSet(poset1, poset2, ...)
}
\arguments{
\item{poset1}{An object of S4 class \code{POSet}.
Argument \code{poset1} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{poset2}{An object of S4 class \code{POSet}.
Argument \code{poset2} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{...}{Optional additional objects of S4 class \code{POSet}.
Optional arguments must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}
}
\value{
The linear sum poset, an object of S4 class \code{POSet}.
}
\description{
Computes the linear sum of the input posets.
}
\details{
Let \eqn{P_1=(V_1,\leq_1),\ldots,P_k=(V_k,\leq_k)} be \eqn{k} posets on disjoint ground sets.
Their linear sum is the poset \eqn{P=(V,\lhd)} having as ground set the union of the input ground sets,
with \eqn{a\leq b} if and only if \eqn{a\leq_i b} for some \eqn{i}, or \eqn{a\in V_i} and \eqn{b\in V_j},
with \eqn{i<j}. In other words, the linear sum is obtained by stacking the input posets from bottom,
and making all of the minimal elements of \eqn{P_i} covering all of the maximal elements of \eqn{P_{i-1}} (\eqn{i>1}).
}
\examples{
elems1 <- c("a", "b", "c", "d")
elems2 <- c("e", "f", "g", "h")

dom1 <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

dom2 <- matrix(c(
  "e", "f",
  "g", "h",
  "h", "f"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = elems1, dom = dom1)

pos2 <- POSet(elements = elems2, dom = dom2)

#Linear sum of pos1 and pos2
lin.sum <- LinearSumPOSet(pos1, pos2)

}
