% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexicographicProductPOSet.R
\name{LexicographicProductPOSet}
\alias{LexicographicProductPOSet}
\title{Computing lexicographic product orders.}
\usage{
LexicographicProductPOSet(poset1, poset2, ...)
}
\arguments{
\item{poset1}{An object of S4 class \code{POSet}.
Argument \code{poset1} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{poset2}{An object of S4 class \code{POSet}.
Argument \code{poset2} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{...}{Optional additional objects of S4 class \code{POSet}.
Optional arguments must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}
}
\value{
The lexicographic product poset, an object of S4 class \code{POSet}.
}
\description{
Computes the lexicographic product order of the input partial orders.
}
\details{
Let \eqn{P_1 = (V_1, \leq_1),\cdots, P_k = (V_k, \leq_k)} be \eqn{k} posets.
The lexicographic product poset \eqn{P_{lxprd}=(V, \leq_{lxprd})} has ground
set the Cartesian product of the input ground sets, with
\eqn{(a_1,\ldots,a_k)\leq_{lxprd} (b_1,\ldots,b_k)} if and only \eqn{a_1\leq_1 b_1},
or there exists \eqn{j} such that \eqn{a_i=b_i} for \eqn{i<j} and \eqn{a_j\leq_j b_j}.
}
\examples{
elems1 <- c("a", "b", "c", "d", "e")
elems2 <- c("f", "g", "h")

dom1 <- matrix(c(
  "a", "b",
  "c", "b",
  "d", "b"
), ncol = 2, byrow = TRUE)

dom2 <- matrix(c(
  "g", "f",
  "h", "f"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = elems1, dom = dom1)

pos2 <- POSet(elements = elems2, dom = dom2)

#Lexicographic product of pos1 and pos2
lex.prod <- LexicographicProductPOSet(pos1, pos2)

}
