% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kde_polysph}
\alias{kde_polysph}
\title{Polyspherical kernel density estimator}
\usage{
kde_polysph(x, X, d, h, weights = as.numeric(c()), log = FALSE,
  wrt_unif = FALSE, normalized = TRUE, intrinsic = FALSE,
  norm_x = FALSE, norm_X = FALSE, kernel = 1L, kernel_type = 1L,
  k = 10)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, sum(d) + r)} with the evaluation
points.}

\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{h}{vector of size \code{r} with bandwidths.}

\item{weights}{weights for each observation. If provided, a vector of size
\code{n} with the weights for multiplying each kernel. If not provided,
set internally to \code{rep(1 / n, n)}, which gives the standard estimator.}

\item{log}{compute the logarithm of the density? Defaults to \code{FALSE}.}

\item{wrt_unif}{flag to return a density with respect to the uniform
measure. If \code{FALSE} (default), the density is with respect to the
Lebesgue measure.}

\item{normalized}{flag to compute the normalizing constant of the kernel
and include it in the kernel density estimator. Defaults to \code{TRUE}.}

\item{intrinsic}{use the intrinsic distance, instead of the
extrinsic-chordal distance, in the kernel? Defaults to \code{FALSE}.}

\item{norm_x, norm_X}{ensure a normalization of the data? Defaults to
\code{FALSE}.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}
}
\value{
A column vector of size \code{c(nx, 1)} with the evaluation of
kernel density estimator.
}
\description{
Computes the kernel density estimator for data on the
polysphere \eqn{\mathcal{S}^{d_1} \times \cdots \times \mathcal{S}^{d_r}}.
Given a sample \eqn{\boldsymbol{X}_1,\ldots,\boldsymbol{X}_n}, this
estimator is
\deqn{\hat{f}(\boldsymbol{x};\boldsymbol{h})=\sum_{i=1}^n
L_{\boldsymbol{h}}(\boldsymbol{x},\boldsymbol{X}_i)}
for a kernel \eqn{L} and a vector of bandwidths \eqn{\boldsymbol{h}}.
}
\examples{
# Simple check on S^1 x S^2
n <- 1e3
d <- c(1, 2)
mu <- c(0, 1, 0, 0, 1)
kappa <- c(5, 5)
h <- c(0.2, 0.2)
X <- r_vmf_polysph(n = n, d = d, mu = mu, kappa = kappa)
kde_polysph(x = rbind(mu), X = X, d = d, h = h)
d_vmf_polysph(x = rbind(mu), d = d, mu = mu, kappa = kappa)
}
