% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permcoefs.plsRbetanp.R
\name{permcoefs.plsRbetanp}
\alias{permcoefs.plsRbetanp}
\title{Coefficients for permutation bootstrap computations of PLSBeta models}
\usage{
permcoefs.plsRbetanp(
  dataRepYtt,
  ind,
  nt,
  modele,
  family = NULL,
  maxcoefvalues,
  wwetoile,
  ifbootfail
)
}
\arguments{
\item{dataRepYtt}{components' coordinates to bootstrap}

\item{ind}{indices for resampling}

\item{nt}{number of components to use}

\item{modele}{type of modele to use, see \link{plsRbeta}}

\item{family}{glm family to use, see \link{plsRbeta}}

\item{maxcoefvalues}{maximum values allowed for the estimates of the
coefficients to discard those coming from singular bootstrap samples}

\item{wwetoile}{values of the Wstar matrix in the original fit}

\item{ifbootfail}{value to return if the estimation fails on a bootstrap
sample}
}
\value{
estimates on a bootstrap sample or \code{ifbootfail} value if the
bootstrap computation fails.
}
\description{
A function passed to \code{boot} to perform bootstrap.
}
\note{
~~some notes~~
}
\examples{
\donttest{
data("GasolineYield",package="betareg")
modplsbeta <- plsRbeta(yield~.,data=GasolineYield,nt=3, modele="pls-beta")
bootplsbeta(modplsbeta, R=250, statistic=permcoefs.plsRbetanp, typeboot="fmodel_np")
}
}
\seealso{
See also \code{\link{bootplsbeta}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
