% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permcoefs.plsRbeta.raw.R
\name{permcoefs.plsRbeta.raw}
\alias{permcoefs.plsRbeta.raw}
\title{Raw coefficients function for permutation bootstrap techniques}
\usage{
permcoefs.plsRbeta.raw(
  dataset,
  ind,
  nt,
  modele,
  family = NULL,
  method = "logistic",
  link = "logit",
  link.phi = NULL,
  type = "ML",
  maxcoefvalues,
  ifbootfail,
  verbose = TRUE
)
}
\arguments{
\item{dataset}{dataset to resample}

\item{ind}{indices for resampling}

\item{nt}{number of components to use}

\item{modele}{name of the PLS glm or PLS beta model to be fitted
(\code{"pls"}, \code{"pls-glm-Gamma"}, \code{"pls-glm-gaussian"},
\code{"pls-glm-inverse.gaussian"}, \code{"pls-glm-logistic"},
\code{"pls-glm-poisson"}, \code{"pls-glm-polr"}, \code{"pls-beta"}). Use
\code{"modele=pls-glm-family"} to enable the \code{family} option.}

\item{family}{family to use if GLM model, see \link{plsRbeta}}

\item{method}{method for beta regression}

\item{link}{link for beta regression}

\item{link.phi}{link.phi for beta regression}

\item{type}{type of estimates}

\item{maxcoefvalues}{maximum values allowed for the estimates of the
coefficients to discard those coming from singular bootstrap samples}

\item{ifbootfail}{value to return if the estimation fails on a}

\item{verbose}{should info messages be displayed ?}
}
\value{
Estimates on a bootstrap sample.
}
\description{
A function passed to \code{boot} to perform bootstrap.
}
\examples{
\donttest{
data("GasolineYield",package="betareg")
modplsbeta <- plsRbeta(yield~.,data=GasolineYield,nt=3, modele="pls-beta")
GazYield.boot.raw <- bootplsbeta(modplsbeta, sim="permutation", stype="i", 
R=250, statistic=coefs.plsRbeta.raw)
}

}
\references{
Frédéric Bertrand, Nicolas Meyer,
Michèle Beau-Faller, Karim El Bayed, Izzie-Jacques Namer,
Myriam Maumy-Bertrand (2013). Régression Bêta
PLS. \emph{Journal de la Société Française de Statistique},
\bold{154}(3):143-159.
\url{http://publications-sfds.math.cnrs.fr/index.php/J-SFdS/article/view/215}
}
\seealso{
See also \code{\link{bootplsbeta}}.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
