% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_piece.R
\name{render_piece}
\alias{render_piece}
\title{Render image of game pieces}
\usage{
render_piece(
  df,
  file = NULL,
  ...,
  .f = piecepackr::grid.piece,
  cfg = getOption("piecepackr.cfg", NULL),
  envir = getOption("piecepackr.envir", game_systems("sans")),
  width = NULL,
  height = NULL,
  ppi = 72,
  bg = "white",
  xoffset = NULL,
  yoffset = NULL,
  annotate = FALSE,
  annotation_scale = NULL,
  dev = NULL,
  dev.args = list(res = ppi, bg = bg, units = "in"),
  open_device = new_device,
  close_device = open_device && (!is.null(file) || !is.null(dev)),
  image = c("NULL", "raster", "nativeRaster"),
  xbreaks = NULL,
  ybreaks = NULL,
  new_device = TRUE
)
}
\arguments{
\item{df}{A data frame of game piece information with (at least) the
named columns \dQuote{piece_side}, \dQuote{x}, and \dQuote{y}.}

\item{file}{Filename to save image to unless \code{NULL}
in which case it either uses the current graphics device or opens a new device
(depending on \code{open_device} argument).}

\item{...}{Arguments to \code{\link[=pmap_piece]{pmap_piece()}}}

\item{.f}{Low level graphics function to use e.g. \code{\link[=grid.piece]{grid.piece()}}, \code{\link[=piece3d]{piece3d()}}, \code{\link[=piece_mesh]{piece_mesh()}}, or \code{\link[=piece]{piece()}}.}

\item{cfg}{A piecepackr configuration list}

\item{envir}{Environment (or named list) of piecepackr configuration lists}

\item{width}{Width of image (in inches).  Inferred by default.}

\item{height}{Height of image (in inches).  Inferred by default.}

\item{ppi}{Resolution of image in pixels per inch.}

\item{bg}{Background color (use \code{"transparent"} for transparent)}

\item{xoffset}{Number to add to the \code{x} column in \code{df}.  Inferred by default.}

\item{yoffset}{Number to add to the \code{y} column in \code{df}.  Inferred by default.}

\item{annotate}{If \code{TRUE} or \code{"algebraic"} annotate the plot
with \dQuote{algrebraic} coordinates,
if \code{FALSE} or \code{"none"} don't annotate,
if \code{"cartesian"} annotate the plot with \dQuote{cartesian} coordinates.}

\item{annotation_scale}{Multiplicative factor that scales (stretches) any annotation coordinates.
By default uses \code{attr(df, "scale_factor") \%||\% 1}.}

\item{dev}{Graphics device function to use if \code{open_device} is \code{FALSE}.
If \code{NULL} infer a reasonable choice from \code{file}.}

\item{dev.args}{Additional arguments to pass to \code{dev} (besides \code{filename}, \code{width}, and \code{height}).
Will filter out any names that aren't in \code{formals(dev)}.}

\item{open_device}{If \code{TRUE} open a new graphics device otherwise draw in the active graphics.}

\item{close_device}{If \code{TRUE} close the graphics device (if \code{open_device = TRUE} close the newly opened device otherwise close the previously existing graphics device).}

\item{image}{Class of image object to return in the \code{"image"} field of returned list.
If \code{"NULL"} (the default) return \code{NULL}.
If \code{"raster"} or \verb{"nativeRaster" try to return a raster object of the image using [grDevices::dev.capture()] or }as.raster(magick::image_read())`.}

\item{xbreaks, ybreaks}{Subset (of integers) to provide axis labels for if \code{annotate} is \code{TRUE}.
If \code{NULL} infer a reasonable choice.}

\item{new_device}{If \code{FALSE} draw in the active graphics device instead of opening a new graphics device.  This argument is deprecated.  Use the \code{open_device} argument instead.}
}
\value{
An invisible list of the dimensions of the image and
possibly an image object specified by \code{image}.
As a side effect may save a file and/or open/close a graphics device.
}
\description{
\code{render_piece()} renders an image of game pieces to a file or graphics device.
It is a wrapper around \code{pmap_piece()} that can auto-size files and graphic devices,
apply axes offsets, annotate coordinates, and set up \code{rayrender} / \code{rayvertex} scenes.
}
\examples{
 df_board <- data.frame(piece_side = "board_face", suit = 3, rank = 5,
                        x = 3.0, y = 3.0, stringsAsFactors = FALSE)
 df_w <- data.frame(piece_side = "bit_back", suit = 6, rank = 1,
                    x = rep(1:5, 2), y = rep(1:2, each=5),
                    stringsAsFactors = FALSE)
 df_b <- data.frame(piece_side = "bit_back", suit = 1, rank = 1,
                    x = rep(1:5, 2), y = rep(4:5, each=5),
                    stringsAsFactors = FALSE)
 df <- rbind(df_board, df_w, df_b)
 df$cfg <- "checkers1"

 if (requireNamespace("grid", quietly = TRUE)) {
   render_piece(df, open_device = FALSE)
 }
 if (requireNamespace("grid", quietly = TRUE)) {
   grid::grid.newpage()
   render_piece(df, open_device = FALSE,
                op_scale = 0.5, trans = op_transform,
                annotate = "algrebraic")
 }
 \dontrun{# May take more than 5 seconds on CRAN servers
 if (require(rayvertex)) {
   envir3d <- game_systems("sans3d")
   render_piece(df, .f = piece_mesh, envir = envir3d,
                open_device = FALSE,
                op_scale = 0.5, trans = op_transform)
 }
 }
}
\seealso{
This function is a wrapper around \code{\link[=pmap_piece]{pmap_piece()}}.
}
