% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_1forex.R
\name{md_forex}
\alias{md_forex}
\title{query forex data}
\usage{
md_forex(symbol, type = "history", date_range = "3y", from = NULL,
  to = Sys.Date(), print_step = 1L, ...)
}
\arguments{
\item{symbol}{forex symbols. Default is NULL.}

\item{type}{the data type, available values including history and real. Default is history.}

\item{date_range}{date range. Available value includes '1m'-'11m', 'ytd', 'max' and '1y'-'ny'. Default is 3y.}

\item{from}{the start date. Default is NULL. If it is NULL, then calculate using date_range and end date.}

\item{to}{the end date. Default is the current date.}

\item{print_step}{a non-negative integer, which will print symbol name by each print_step iteration. Default is 1L.}

\item{...}{Additional parameters.}
}
\description{
\code{md_forex} query forex market data from FRED (history data) or sina (real data).
}
\examples{
\dontrun{
# history data
dtfx_hist1 = md_forex(c('usdcny', 'usdjpy'))

# real data
dtfx_real = md_forex(c('eurusd', 'usdcny', 'usdjpy'), type = 'real')

}


}
