% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_final_signature}
\alias{get_final_signature}
\title{Filter cancer-specific dysfunction pathways.}
\usage{
get_final_signature(PTMB, sur, pval_cutoff = 0.01)
}
\arguments{
\item{PTMB}{The pathway tumor mutation burden matrix,generated by`get_PTMB`.}

\item{sur}{A nx2 data frame of samples' survival data,the first line is samples' survival event and the second line is samples' overall survival.}

\item{pval_cutoff}{A threshold value (0.01 as the default value) to identify the differential PTMB pathway.}
}
\value{
Return the final PTMB signature,could be a potential marker for prognostic and immunotherapy prediction.
}
\description{
The function `get_final_signature` , using to filter cancer-specific dysfunction pathways (a potential marker for cancer prognostic and immunotherapy), is the main function of our analysis.
}
\examples{
#get the path of the mutation annotation file and samples' survival data
maf<-system.file("extdata","data_mutations_extended.txt",package = "pathwayTMB")
\donttest{sur_path<-system.file("extdata","sur.csv",package = "pathwayTMB")
sur<-read.csv(sur_path,header=TRUE,row.names = 1)
#perform the function 'get_mut_matrix'
mut_matrix<-get_mut_matrix(maffile=maf,mut_fre = 0.01,is.TCGA=FALSE,sur=sur)
#perform the function `get_PTMB`
PTMB_matrix<-get_PTMB(freq_matrix=mut_matrix,genesmbol=genesmbol,gene_path=gene_path)
set.seed(1)
final_character<-get_final_signature(PTMB=PTMB_matrix,sur=sur)}
}
