% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{show_authors}
\alias{show_authors}
\title{Simplify the OpenAlex authors result}
\usage{
show_authors(x, simp_func = utils::head)
}
\arguments{
\item{x}{Dataframe/tibble. Result of the OpenAlex query for authors
already converted to dataframe/tibble.}

\item{simp_func}{R function to simplify the result. Default to `head`.
If you want the entire table, set `simp_fun = identity`}
}
\value{
Simplified tibble to display.
The first column, `id` is the short-form OpenAlex ID of the authors.
}
\description{
This function is mostly for the package's internal use,
but we export it so you can try it out.
However, we expect that you'll likely write your own function to
simplify the result however you want.
}
\examples{

show_authors(oa_fetch(
  identifier = c("A5023888391", "A5014077037"),
  verbose = TRUE
))

}
