% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCdmReference.R
\name{$<-.cdm_reference}
\alias{$<-.cdm_reference}
\title{Assign an table to a cdm reference.}
\usage{
\method{$}{cdm_reference}(cdm, name) <- value
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{Name where to assign the new table.}

\item{value}{Table with the same source than the cdm object.}
}
\value{
The cdm reference.
}
\description{
Assign an table to a cdm reference.
}
\examples{
\donttest{
library(omopgenerics)

cdm <- cdmFromTables(
  tables = list(
    "person" = dplyr::tibble(
      person_id = c(1, 2, 3), gender_concept_id = 0, year_of_birth = 1990,
      race_concept_id = 0, ethnicity_concept_id = 0
    ),
    "observation_period" = dplyr::tibble(
      observation_period_id = 1:3, person_id = 1:3,
      observation_period_start_date = as.Date("2000-01-01"),
      observation_period_end_date = as.Date("2023-12-31"),
      period_type_concept_id = 0
    )
  ),
  cdmName = "mock"
)

cdm$person
}
}
