% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFEFG.R
\name{calcFEFG}
\alias{calcFEFG}
\title{Calculates Founder Equivalents and Founder Genome Equivalents}
\usage{
calcFEFG(ped, alleles)
}
\arguments{
\item{ped}{the pedigree information in datatable format.  Pedigree
(req. fields: id, sire, dam, gen, population).

It is assumed that the pedigree has no partial parentage}

\item{alleles}{dataframe contains an \code{AlleleTable}. This is a
table of allele information produced by \code{geneDrop()}.}
}
\value{
The list containing the founder equivalents,
\code{FE = 1 / sum(p ^ 2)}, and the founder genome equivalents,
\code{FG = 1 / sum( (p ^ 2) / r} where \code{p} is average number of
descendants and \code{r} is the mean number of founder alleles retained
in the gene dropping experiment.
}
\description{
Part of the Genetic Value Analysis
}
\examples{
data(lacy1989Ped)
## Example from Analysis of Founder Representation in Pedigrees: Founder
## Equivalents and Founder Genome Equivalents.
## Zoo Biology 8:111-123, (1989) by Robert C. Lacy

library(nprcgenekeepr)
ped <- nprcgenekeepr::lacy1989Ped
alleles <- lacy1989PedAlleles
pedFactors <- data.frame(
  id = as.factor(ped$id),
  sire = as.factor(ped$sire),
  dam = as.factor(ped$dam),
  gen = ped$gen,
  population = ped$population,
  stringsAsFactors = TRUE
)
allelesFactors <- geneDrop(pedFactors$id, pedFactors$sire, pedFactors$dam,
  pedFactors$gen,
  genotype = NULL, n = 5000,
  updateProgress = NULL
)
feFg <- calcFEFG(ped, alleles)
feFgFactors <- calcFEFG(pedFactors, allelesFactors)
}
