% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dirutils}
\alias{dirutils}
\alias{list_dbfs}
\alias{list_dats}
\alias{is_file}
\alias{is_dir}
\alias{find_known_liposome_dat_file}
\alias{find_known_liposome_dbf_file}
\title{Directory Utils}
\usage{
list_dbfs(pathstring)

list_dats(pathstring)

is_file(pathstring)

is_dir(pathstring = NULL)

find_known_liposome_dat_file(fpath, fname)

find_known_liposome_dbf_file(fpath, fname)
}
\arguments{
\item{pathstring}{path string}

\item{fpath}{fpath}

\item{fname}{fname}
}
\value{
directory utils

dbfs

dbfs

dbfs

dbfs

dbfs

dbfs
}
\description{
A function that facilitates a users' workflow by helping to check for DBFs in a directory.

A function that facilitates a users' workflow by helping to check for DATs in a directory.
}
\examples{
\dontrun{
fpath <- system.file("extdata", package = "normfluodbf", mustWork = TRUE)
list_dbfs(fpath)
list_dats(fpath)
is_file(fpath)
find_known_liposome_dat_file(fpath, 'dat_1.dat')
find_known_liposome_dbf_file(fpath, 'liposomes_218')}
}
\seealso{
Other dirutils: 
\code{\link{normfluodbfcomms}},
\code{\link{sampledata}}
}
\concept{dirutils}
