% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.index.R
\name{aggregate_positions}
\alias{aggregate_positions}
\title{Quantification of (indirect) relations}
\usage{
aggregate_positions(tau_x, type = "sum")
}
\arguments{
\item{tau_x}{Numeric matrix containing indirect relations calculated with \link{indirect_relations}.}

\item{type}{String indicating the type of aggregation to be used. See Details for options.}
}
\value{
Scores for the index defined by the indirect relation \code{tau_x} and the
used aggregation type.
}
\description{
Function to aggregate positions defined via indirect relations to construct centrality
scores.
}
\details{
The predefined functions are mainly wrappers around base R functions.
type='sum', for instance, is equivalent to \code{rowSums()}. A non-base functions is
type='invsum' which calculates the inverse of type='sum'.
type='self' is mostly useful for walk based relations, e.g. to count closed walks.
Other self explanatory options are type='mean', type='min', type='max' and type='prod'.
}
\examples{
library(igraph)
library(magrittr)

data("dbces11")
#degree
dbces11 \%>\% indirect_relations(type='adjacency') \%>\% 
 aggregate_positions(type='sum')

#closeness centrality
dbces11 \%>\% indirect_relations(type='dist_sp') \%>\% 
  aggregate_positions(type='invsum')
  
#betweenness centrality
dbces11 \%>\% indirect_relations(type='depend_sp') \%>\% 
  aggregate_positions(type='sum')
  
#eigenvector centrality
dbces11 \%>\% indirect_relations(type='walks',FUN=walks_limit_prop) \%>\% 
  aggregate_positions(type='sum')

#subgraph centrality
dbces11 \%>\% indirect_relations(type='walks',FUN=walks_exp) \%>\% 
  aggregate_positions(type='self')
  
}
\seealso{
\link{indirect_relations}, \link{transform_relations}
}
\author{
David Schoch
}
