% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_chart.R
\name{ph_with.ms_chart}
\alias{ph_with.ms_chart}
\title{add a MS Chart output into a PowerPoint object}
\usage{
\method{ph_with}{ms_chart}(x, value, location, ...)
}
\arguments{
\item{x}{a pptx device}

\item{value}{chart object}

\item{location}{a location for a placeholder.}

\item{...}{Arguments to be passed to methods.}
}
\description{
produces a Microsoft Chart graphics output from R instructions
and add the result in a PowerPoint document object produced
by \code{\link[=read_pptx]{read_pptx()}}.
}
\examples{
my_barchart <- ms_barchart(data = browser_data,
  x = "browser", y = "value", group = "serie")
my_barchart <- chart_settings( x = my_barchart,
  dir="vertical", grouping="clustered", gap_width = 50 )
my_barchart <- chart_ax_x( x= my_barchart,
  cross_between = 'between', major_tick_mark="out")
my_barchart <- chart_ax_y( x= my_barchart,
  cross_between = "midCat", major_tick_mark="in")

library(officer)
doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with(doc, my_barchart, location = ph_location_fullsize())

fileout <- tempfile(fileext = ".pptx")
print(doc, target = fileout)
}
